package com.ejie.aa17a.control.comun;

import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.ejie.aa17a.model.comun.Aa17aCombo;
import com.ejie.aa17a.service.iface.comun.Aa17aComboService;

/**
 * 
 * @author francisco.galvez
 * 
 */
@RequestMapping(value = "/combo")
public class Aa17aComboController {

	private static final Logger logger = LoggerFactory
			.getLogger(Aa17aComboController.class);

	private Aa17aComboService aa17aComboService;

	/**
	 * Obtiene la lista de valores posibles de archivado.
	 * 
	 * @return List<Aa17aCombo>-. Lista de objetos combo
	 */
	@RequestMapping(value = "estaciones", method = RequestMethod.GET)
	public @ResponseBody
	List<Aa17aCombo> getComboEstaciones() {
		Aa17aComboController.logger
				.info("[GET - jqGrid] : Rellenar el combo de Estaciones");
		return this.aa17aComboService.findComboEstaciones();
	}

	/**
	 * Obtiene la lista de valores posibles de archivado.
	 * 
	 * @param idEstacion
	 *            Long
	 * @return List<Aa17aCombo>-. Lista de objetos combo
	 */
	@RequestMapping(value = "contaminantes", method = RequestMethod.GET)
	public @ResponseBody
	List<Aa17aCombo> getComboContaminantesEstacion(@RequestParam(value = "idEstacion", required = false) Long idEstacion) {
		Aa17aComboController.logger
				.info("[GET - jqGrid] : Rellenar el combo de Estaciones");
		return this.aa17aComboService.findComboContaminantesEstacion(idEstacion);
	}

	/**
	 * @param aa17aComboService
	 *            the aa17aComboService to set
	 */
	public void setAa17aComboService(Aa17aComboService aa17aComboService) {
		this.aa17aComboService = aa17aComboService;
	}

}